﻿using System;
using System.Runtime.InteropServices;
using System.Text;

namespace Sony
{
	namespace NP
	{
		public class Requests
	    {
	        [DllImport("UnityNpToolkit")]
	        private static extern ErrorCode PrxNpRequestCheckPlus(int userid, ulong features);
			[DllImport("UnityNpToolkit")]
			private static extern ErrorCode PrxNpRequestCheckPlusDefaultUser(ulong features);
			[DllImport("UnityNpToolkit")]
			private static extern ErrorCode PrxNpRequestNotifyPlusFeature(int userid, ulong features);
			[DllImport("UnityNpToolkit")]
			private static extern ErrorCode PrxNpRequestNotifyPlusFeatureDefaultUser(ulong features);

			[DllImport("UnityNpToolkit", CharSet = CharSet.Ansi)]
			private static extern ErrorCode PrxNpRequestGetAccountLanguage(string onlineID);
			[DllImport("UnityNpToolkit", CharSet = CharSet.Ansi)]
			private static extern ErrorCode PrxNpRequestGetParentalControlInfo(string onlineID);
			[DllImport("UnityNpToolkit", CharSet = CharSet.Ansi)]
			private static extern ErrorCode PrxNpRequestCheckNpAvailability(string onlineID);
			[DllImport("UnityNpToolkit", CharSet = CharSet.Ansi)]
			private static extern ErrorCode PrxNpRequestSetGamePresenceOnline(string onlineID);

	        public static event Messages.EventHandler OnCheckPlusResult;
			public static event Messages.EventHandler OnAccountLanguageResult;
			public static event Messages.EventHandler OnParentalControlResult;

			[Flags]
			public enum PlusFeature
			{
				NONE = 0,
				REALTIME_MULTIPLAY = 1,
				ASYNC_MULTIPLAY = 2
			};

			public static ErrorCode CheckPlus(int userid, PlusFeature features)
	        {
	            return PrxNpRequestCheckPlus(userid, (ulong)features);
	        }

			public static ErrorCode CheckPlus(PlusFeature features)
			{
				return PrxNpRequestCheckPlusDefaultUser((ulong)features);
			}

			public static ErrorCode NotifyPlusFeature(int userid, PlusFeature features)
			{
				return PrxNpRequestNotifyPlusFeature(userid, (ulong)features);
			}
			
			public static ErrorCode NotifyPlusFeature(PlusFeature features)
			{
				return PrxNpRequestNotifyPlusFeatureDefaultUser((ulong)features);
			}


			public static ErrorCode GetAccountLanguage(string onlineId)
			{
				return PrxNpRequestGetAccountLanguage(onlineId);
			}

			public static ErrorCode GetParentalControlInfo(string onlineId)
			{
				return PrxNpRequestGetParentalControlInfo(onlineId);
			}

			public static ErrorCode CheckNpAvailability(string onlineId)
			{
				return PrxNpRequestCheckNpAvailability(onlineId);
			}

			public static ErrorCode SetGamePresenceOnline(string onlineId)
			{
				return PrxNpRequestSetGamePresenceOnline(onlineId);
			}


	        public static bool ProcessMessage(NP.Messages.PluginMessage msg)
	        {
	            switch (msg.type)
	            {
	                case NP.Messages.MessageType.kNPToolKit_CheckPlusResult:
	                    if (OnCheckPlusResult != null) OnCheckPlusResult(msg);
	                    return true;
				
					case NP.Messages.MessageType.kNPToolKit_AccountLanguageResult:
						if (OnAccountLanguageResult != null) OnAccountLanguageResult(msg);
							return true;
					case NP.Messages.MessageType.kNPToolKit_ParentalControlResult:
						if (OnParentalControlResult != null) OnParentalControlResult(msg);
							return true;

				}

	            return false;
	        }

			public static void GetCheckPlusResult(NP.Messages.PluginMessage msg, out bool CheckPlusResult, out int userId)
			{
				CheckPlusResult = false;
				int plusoffset = 64;
				byte plusresult = Marshal.ReadByte (msg.data, plusoffset);
				if (plusresult != 0)
				{
					CheckPlusResult = true;
				}

				int idoffset = 16;
				userId = Marshal.ReadInt32 (msg.data, idoffset);

			}

            public static string GetAccountLanguageResult(NP.Messages.PluginMessage msg)
			{
                int offset = 28;
				IntPtr ptr = new IntPtr(msg.data.ToInt64() + offset);
				return Marshal.PtrToStringAnsi(ptr);
			}

			public static string GetRequestOnlineId(NP.Messages.PluginMessage msg)
			{
				int offset = 8;
				IntPtr ptr = new IntPtr(msg.data.ToInt64() + offset);
				return Marshal.PtrToStringAnsi(ptr);
			}



            public static byte[] GetRequestResultData(NP.Messages.PluginMessage msg)
            {
                byte[] bytes = new byte[msg.dataSize];
                Marshal.Copy(msg.data, bytes, 0, msg.dataSize);
                return bytes;
            }

			public static void GetParentalControlInfoResult(NP.Messages.PluginMessage msg, out int Age, out bool chatRestriction, out bool ugcRestriction)
			{
				byte[] bytes = new byte[msg.dataSize];
				Marshal.Copy(msg.data, bytes, 0, msg.dataSize);
				Age = (int)bytes[28];
				chatRestriction = (bytes[30]==1)? true : false;
				ugcRestriction = (bytes[31]==1)? true : false;
				return;
			}
            
	    }
	}
}
